
-- Création de la base de données et des tables
CREATE DATABASE IF NOT EXISTS LabMedical;
USE LabMedical;

CREATE TABLE IF NOT EXISTS Patient (
    id_patient INT AUTO_INCREMENT PRIMARY KEY,
    nom VARCHAR(50) NOT NULL,
    prenom VARCHAR(50) NOT NULL,
    date_naissance DATE NOT NULL,
    adresse VARCHAR(255),
    telephone VARCHAR(15),
    email VARCHAR(100) UNIQUE
);

CREATE TABLE IF NOT EXISTS Analyse (
    id_analyse INT AUTO_INCREMENT PRIMARY KEY,
    type_analyse VARCHAR(100) NOT NULL,
    description TEXT,
    cout DECIMAL(8,2) NOT NULL
);

CREATE TABLE IF NOT EXISTS Resultat (
    id_resultat INT AUTO_INCREMENT PRIMARY KEY,
    id_patient INT,
    id_analyse INT,
    date_analyse DATE NOT NULL,
    valeur_resultat VARCHAR(100),
    unite VARCHAR(20),
    interpretation VARCHAR(255),
    FOREIGN KEY (id_patient) REFERENCES Patient(id_patient) ON DELETE CASCADE,
    FOREIGN KEY (id_analyse) REFERENCES Analyse(id_analyse) ON DELETE CASCADE
);

-- Insertion des patients
INSERT INTO Patient (nom, prenom, date_naissance, adresse, telephone, email) VALUES
('Martin', 'Paul', '1975-09-19', '10 Rue de la Santé, Paris', '+33 6 32572679', 'paul.martin@laposte.net'),
('Durand', 'Paul', '2012-12-31', '17 Rue des Hôpitaux, Toulouse', '+33 6 49277336', 'paul.durand@gmail.com'),
('Dupont', 'Luc', '2015-08-04', '10 Rue de la Santé, Paris', '+33 6 59395629', 'luc.dupont@hotmail.com'),
('Simon', 'Jean', '1974-03-09', '32 Boulevard Pasteur, Marseille', '+33 6 20254075', 'jean.simon@gmail.com'),
('Richard', 'Marie', '2017-10-27', '32 Boulevard Pasteur, Marseille', '+33 6 68147254', 'marie.richard@laposte.net'),
('Dupont', 'Jean', '2016-06-01', '10 Rue de la Santé, Paris', '+33 6 87113489', 'jean.dupont@yahoo.fr'),
('Petit', 'Marie', '2003-11-04', '50 Cours de Médecine, Bordeaux', '+33 6 78864627', 'marie.petit@gmail.com'),
('Petit', 'Claire', '2006-02-15', '25 Avenue Médicale, Lyon', '+33 6 62944922', 'claire.petit@yahoo.fr'),
('Simon', 'Paul', '2016-10-24', '10 Rue de la Santé, Paris', '+33 6 48545277', 'paul.simon@hotmail.com'),
('Moreau', 'Marie', '1990-08-08', '50 Cours de Médecine, Bordeaux', '+33 6 12584069', 'marie.moreau@laposte.net'),
('Bernard', 'Nathalie', '2010-07-12', '10 Rue de la Santé, Paris', '+33 6 26792664', 'nathalie.bernard@hotmail.com'),
('Durand', 'Marie', '2000-09-20', '17 Rue des Hôpitaux, Toulouse', '+33 6 76830231', 'marie.durand@laposte.net'),
('Laurent', 'Nathalie', '1971-03-03', '25 Avenue Médicale, Lyon', '+33 6 27139322', 'nathalie.laurent@gmail.com'),
('Dupont', 'Julien', '1993-05-12', '10 Rue de la Santé, Paris', '+33 6 82249011', 'julien.dupont@orange.fr'),
('Robert', 'Paul', '2002-10-10', '50 Cours de Médecine, Bordeaux', '+33 6 80569092', 'paul.robert@laposte.net'),
('Dupont', 'Jean', '2001-09-14', '25 Avenue Médicale, Lyon', '+33 6 12948436', 'jean.dupont@orange.fr'),
('Martin', 'Marie', '2012-11-29', '50 Cours de Médecine, Bordeaux', '+33 6 48796249', 'marie.martin@hotmail.com'),
('Simon', 'Julien', '1974-06-27', '10 Rue de la Santé, Paris', '+33 6 79733154', 'julien.simon@hotmail.com'),
('Dupont', 'Marie', '2017-01-27', '32 Boulevard Pasteur, Marseille', '+33 6 17340697', 'marie.dupont@gmail.com'),
('Laurent', 'Camille', '2017-05-05', '32 Boulevard Pasteur, Marseille', '+33 6 40490225', 'camille.laurent@laposte.net'),
('Bernard', 'Claire', '2011-08-31', '50 Cours de Médecine, Bordeaux', '+33 6 46698618', 'claire.bernard@yahoo.fr'),
('Moreau', 'Marie', '2017-09-19', '17 Rue des Hôpitaux, Toulouse', '+33 6 33394572', 'marie.moreau@yahoo.fr'),
('Robert', 'Jean', '2005-09-11', '17 Rue des Hôpitaux, Toulouse', '+33 6 88314028', 'jean.robert@orange.fr'),
('Bernard', 'Paul', '1996-10-30', '10 Rue de la Santé, Paris', '+33 6 62051438', 'paul.bernard@hotmail.com'),
('Richard', 'Nathalie', '2005-04-29', '32 Boulevard Pasteur, Marseille', '+33 6 53242572', 'nathalie.richard@orange.fr'),
('Robert', 'Sophie', '1991-08-11', '10 Rue de la Santé, Paris', '+33 6 91925444', 'sophie.robert@hotmail.com'),
('Petit', 'Thomas', '1979-03-27', '10 Rue de la Santé, Paris', '+33 6 56667019', 'thomas.petit@gmail.com'),
('Richard', 'Claire', '1991-12-14', '17 Rue des Hôpitaux, Toulouse', '+33 6 64949986', 'claire.richard@gmail.com'),
('Laurent', 'Julien', '1976-10-07', '17 Rue des Hôpitaux, Toulouse', '+33 6 36537102', 'julien.laurent@laposte.net'),
('Bernard', 'Jean', '2013-08-23', '10 Rue de la Santé, Paris', '+33 6 28184128', 'jean.bernard@hotmail.com'),
('Dupont', 'Marie', '1978-10-12', '50 Cours de Médecine, Bordeaux', '+33 6 92477363', 'marie.dupont@hotmail.com'),
('Laurent', 'Luc', '1970-02-20', '50 Cours de Médecine, Bordeaux', '+33 6 43043965', 'luc.laurent@laposte.net'),
('Martin', 'Luc', '1979-07-19', '10 Rue de la Santé, Paris', '+33 6 66158155', 'luc.martin@hotmail.com'),
('Durand', 'Thomas', '1982-07-30', '32 Boulevard Pasteur, Marseille', '+33 6 93691015', 'thomas.durand@laposte.net'),
('Dupont', 'Camille', '2014-04-28', '50 Cours de Médecine, Bordeaux', '+33 6 39295536', 'camille.dupont@yahoo.fr'),
('Laurent', 'Paul', '2017-11-05', '17 Rue des Hôpitaux, Toulouse', '+33 6 97858497', 'paul.laurent@hotmail.com'),
('Dupont', 'Julien', '1996-01-17', '17 Rue des Hôpitaux, Toulouse', '+33 6 79679989', 'julien.dupont@yahoo.fr'),
('Simon', 'Julien', '1972-08-31', '50 Cours de Médecine, Bordeaux', '+33 6 80613502', 'julien.simon@gmail.com'),
('Simon', 'Marie', '1970-03-27', '50 Cours de Médecine, Bordeaux', '+33 6 24458433', 'marie.simon@laposte.net'),
('Durand', 'Julien', '2012-04-17', '17 Rue des Hôpitaux, Toulouse', '+33 6 90279279', 'julien.durand@hotmail.com'),
('Moreau', 'Julien', '2014-06-04', '32 Boulevard Pasteur, Marseille', '+33 6 57012132', 'julien.moreau@hotmail.com'),
('Simon', 'Jean', '1970-10-09', '10 Rue de la Santé, Paris', '+33 6 83738052', 'jean.simon@yahoo.fr'),
('Simon', 'Camille', '2016-11-04', '17 Rue des Hôpitaux, Toulouse', '+33 6 73988027', 'camille.simon@yahoo.fr'),
('Richard', 'Jean', '1969-05-16', '32 Boulevard Pasteur, Marseille', '+33 6 24616031', 'jean.richard@gmail.com'),
('Robert', 'Nathalie', '1993-07-06', '17 Rue des Hôpitaux, Toulouse', '+33 6 85160608', 'nathalie.robert@gmail.com'),
('Bernard', 'Camille', '1973-04-19', '50 Cours de Médecine, Bordeaux', '+33 6 79119498', 'camille.bernard@laposte.net'),
('Moreau', 'Julien', '1980-09-01', '17 Rue des Hôpitaux, Toulouse', '+33 6 37561224', 'julien.moreau@laposte.net'),
('Durand', 'Marie', '2006-01-16', '17 Rue des Hôpitaux, Toulouse', '+33 6 68020001', 'marie.durand@gmail.com'),
('Simon', 'Nathalie', '1993-08-29', '25 Avenue Médicale, Lyon', '+33 6 80506634', 'nathalie.simon@laposte.net'),
('Laurent', 'Camille', '2014-11-28', '32 Boulevard Pasteur, Marseille', '+33 6 75154859', 'camille.laurent@yahoo.fr'),
('Laurent', 'Claire', '2018-04-06', '17 Rue des Hôpitaux, Toulouse', '+33 6 13152393', 'claire.laurent@orange.fr'),
('Durand', 'Sophie', '1996-12-14', '25 Avenue Médicale, Lyon', '+33 6 30486283', 'sophie.durand@yahoo.fr'),
('Bernard', 'Marie', '1972-07-30', '10 Rue de la Santé, Paris', '+33 6 53290296', 'marie.bernard@yahoo.fr'),
('Moreau', 'Marie', '2005-10-18', '32 Boulevard Pasteur, Marseille', '+33 6 56507610', 'marie.moreau@orange.fr'),
('Laurent', 'Thomas', '1996-09-15', '17 Rue des Hôpitaux, Toulouse', '+33 6 39365913', 'thomas.laurent@laposte.net'),
('Moreau', 'Thomas', '1986-06-10', '50 Cours de Médecine, Bordeaux', '+33 6 76259407', 'thomas.moreau@orange.fr'),
('Petit', 'Camille', '2009-07-16', '50 Cours de Médecine, Bordeaux', '+33 6 88864176', 'camille.petit@orange.fr'),
('Moreau', 'Nathalie', '2017-07-12', '50 Cours de Médecine, Bordeaux', '+33 6 53514565', 'nathalie.moreau@gmail.com'),
('Bernard', 'Luc', '2014-10-31', '25 Avenue Médicale, Lyon', '+33 6 69957085', 'luc.bernard@orange.fr'),
('Dupont', 'Paul', '1979-03-22', '25 Avenue Médicale, Lyon', '+33 6 65535196', 'paul.dupont@orange.fr'),
('Petit', 'Julien', '1977-06-30', '25 Avenue Médicale, Lyon', '+33 6 15365097', 'julien.petit@hotmail.com'),
('Martin', 'Jean', '2003-07-02', '25 Avenue Médicale, Lyon', '+33 6 59731577', 'jean.martin@gmail.com'),
('Dupont', 'Luc', '1986-09-16', '32 Boulevard Pasteur, Marseille', '+33 6 76041249', 'luc.dupont@gmail.com'),
('Moreau', 'Claire', '1970-08-19', '50 Cours de Médecine, Bordeaux', '+33 6 26972981', 'claire.moreau@yahoo.fr'),
('Moreau', 'Jean', '2001-12-26', '17 Rue des Hôpitaux, Toulouse', '+33 6 56192523', 'jean.moreau@yahoo.fr'),
('Petit', 'Thomas', '2013-06-25', '50 Cours de Médecine, Bordeaux', '+33 6 23634228', 'thomas.petit@laposte.net'),
('Robert', 'Claire', '1983-06-11', '10 Rue de la Santé, Paris', '+33 6 33651962', 'claire.robert@gmail.com'),
('Bernard', 'Paul', '1982-10-07', '32 Boulevard Pasteur, Marseille', '+33 6 85103905', 'paul.bernard@orange.fr'),
('Dupont', 'Camille', '1995-04-10', '17 Rue des Hôpitaux, Toulouse', '+33 6 29177482', 'camille.dupont@gmail.com'),
('Robert', 'Julien', '2010-05-14', '10 Rue de la Santé, Paris', '+33 6 55700769', 'julien.robert@gmail.com'),
('Robert', 'Luc', '2001-01-30', '17 Rue des Hôpitaux, Toulouse', '+33 6 49280598', 'luc.robert@laposte.net'),
('Laurent', 'Paul', '1978-10-25', '32 Boulevard Pasteur, Marseille', '+33 6 94403765', 'paul.laurent@laposte.net'),
('Robert', 'Luc', '2008-05-21', '17 Rue des Hôpitaux, Toulouse', '+33 6 32281798', 'luc.robert@yahoo.fr'),
('Durand', 'Camille', '2017-02-12', '10 Rue de la Santé, Paris', '+33 6 51800565', 'camille.durand@gmail.com'),
('Bernard', 'Thomas', '1984-09-09', '10 Rue de la Santé, Paris', '+33 6 72315113', 'thomas.bernard@gmail.com'),
('Moreau', 'Nathalie', '2017-04-30', '32 Boulevard Pasteur, Marseille', '+33 6 73209508', 'nathalie.moreau@hotmail.com'),
('Laurent', 'Marie', '2004-11-28', '25 Avenue Médicale, Lyon', '+33 6 77223572', 'marie.laurent@gmail.com'),
('Durand', 'Thomas', '2002-04-01', '10 Rue de la Santé, Paris', '+33 6 66284575', 'thomas.durand@orange.fr'),
('Laurent', 'Jean', '2003-12-19', '50 Cours de Médecine, Bordeaux', '+33 6 16871599', 'jean.laurent@gmail.com'),
('Simon', 'Camille', '1974-10-14', '25 Avenue Médicale, Lyon', '+33 6 36262564', 'camille.simon@laposte.net'),
('Richard', 'Claire', '1991-05-23', '50 Cours de Médecine, Bordeaux', '+33 6 93188907', 'claire.richard@orange.fr'),
('Petit', 'Paul', '1969-08-30', '17 Rue des Hôpitaux, Toulouse', '+33 6 57379827', 'paul.petit@gmail.com'),
('Moreau', 'Sophie', '1977-01-14', '10 Rue de la Santé, Paris', '+33 6 43792035', 'sophie.moreau@yahoo.fr'),
('Petit', 'Thomas', '2010-09-08', '32 Boulevard Pasteur, Marseille', '+33 6 88804767', 'thomas.petit@orange.fr'),
('Simon', 'Sophie', '2000-04-23', '32 Boulevard Pasteur, Marseille', '+33 6 72454364', 'sophie.simon@laposte.net'),
('Laurent', 'Claire', '2007-05-02', '17 Rue des Hôpitaux, Toulouse', '+33 6 40837354', 'claire.laurent@gmail.com'),
('Durand', 'Luc', '1983-12-17', '50 Cours de Médecine, Bordeaux', '+33 6 47679111', 'luc.durand@gmail.com'),
('Dupont', 'Nathalie', '1977-01-20', '50 Cours de Médecine, Bordeaux', '+33 6 59904040', 'nathalie.dupont@laposte.net'),
('Bernard', 'Claire', '1981-08-15', '32 Boulevard Pasteur, Marseille', '+33 6 51901626', 'claire.bernard@gmail.com'),
('Laurent', 'Sophie', '2002-09-01', '50 Cours de Médecine, Bordeaux', '+33 6 49460128', 'sophie.laurent@laposte.net'),
('Simon', 'Claire', '1982-09-12', '17 Rue des Hôpitaux, Toulouse', '+33 6 29830163', 'claire.simon@hotmail.com'),
('Robert', 'Marie', '1991-02-11', '50 Cours de Médecine, Bordeaux', '+33 6 57114812', 'marie.robert@hotmail.com'),
('Martin', 'Marie', '1999-03-21', '25 Avenue Médicale, Lyon', '+33 6 34251137', 'marie.martin@orange.fr'),
('Laurent', 'Luc', '2013-06-22', '50 Cours de Médecine, Bordeaux', '+33 6 66796663', 'luc.laurent@yahoo.fr'),
('Dupont', 'Camille', '1986-02-22', '17 Rue des Hôpitaux, Toulouse', '+33 6 72535446', 'camille.dupont@laposte.net'),
('Martin', 'Jean', '2009-02-23', '25 Avenue Médicale, Lyon', '+33 6 91475150', 'jean.martin@orange.fr'),
('Richard', 'Marie', '1998-06-27', '17 Rue des Hôpitaux, Toulouse', '+33 6 95868668', 'marie.richard@orange.fr'),
('Robert', 'Luc', '1989-07-25', '25 Avenue Médicale, Lyon', '+33 6 89621045', 'luc.robert@hotmail.com'),
('Petit', 'Camille', '2002-07-02', '50 Cours de Médecine, Bordeaux', '+33 6 53592304', 'camille.petit@yahoo.fr'),
('Richard', 'Paul', '1974-01-24', '50 Cours de Médecine, Bordeaux', '+33 6 94065514', 'paul.richard@hotmail.com');

-- Insertion des analyses médicales
INSERT INTO Analyse (type_analyse, description, cout) VALUES
('Glycémie', "Dosage du glucose dans le sang", 20.0),
('Cholestérol', "Dosage du cholestérol total", 25.0),
('Triglycérides', "Mesure des triglycérides sanguins", 22.0),
('Créatinine', "Évaluation de la fonction rénale", 18.0),
('Hémoglobine', "Mesure de la concentration d''hémoglobine", 15.0),
('Plaquettes', "Numération plaquettaire", 30.0),
('ASAT', "Dosage de l''aspartate aminotransférase (enzyme hépatique)", 28.0),
('ALAT', "Dosage de l''alanine aminotransférase (enzyme hépatique)", 29.0),
('Ferritine', "Évaluation des réserves en fer", 35.0),
('PCR', "Test de détection de pathogènes (ex: COVID-19)", 50.0);

-- Insertion des résultats d'analyses
INSERT INTO Resultat (id_patient, id_analyse, date_analyse, valeur_resultat, unite, interpretation) VALUES
(94, 7, '2023-05-26', 55.45, 'mg/dL', 'Valeur normale'),
(88, 8, '2023-04-07', 43.23, 'g/L', 'Légèrement élevé'),
(25, 5, '2023-09-27', 94.89, 'ng/mL', 'Légèrement bas'),
(65, 5, '2023-01-09', 106.43, 'g/L', 'Valeur normale'),
(54, 5, '2023-06-12', 118.29, 'UI/L', 'Légèrement bas'),
(61, 3, '2023-09-29', 98.82, 'ng/mL', 'Légèrement bas'),
(36, 8, '2023-12-25', 88.35, 'UI/L', 'Légèrement élevé'),
(67, 10, '2023-01-03', 36.44, 'UI/L', 'Anormal'),
(41, 10, '2023-08-10', 144.02, 'g/L', 'Légèrement élevé'),
(2, 8, '2023-07-25', 45.48, 'g/L', 'Légèrement bas'),
(72, 8, '2023-08-28', 191.93, 'g/L', 'Légèrement élevé'),
(9, 8, '2023-05-19', 167.85, 'UI/L', 'Valeur normale'),
(94, 9, '2023-01-12', 171.0, 'g/L', 'Anormal'),
(76, 3, '2023-08-23', 170.43, 'g/L', 'Valeur normale'),
(76, 6, '2023-06-05', 77.82, 'mg/dL', 'Légèrement élevé'),
(61, 6, '2023-11-18', 146.66, 'mg/dL', 'Anormal'),
(61, 6, '2023-07-23', 198.79, 'ng/mL', 'Valeur normale'),
(12, 3, '2023-04-06', 6.41, 'UI/L', 'Légèrement bas'),
(22, 8, '2023-04-19', 50.39, 'mg/dL', 'Anormal'),
(100, 3, '2023-03-02', 182.24, 'UI/L', 'Valeur normale'),
(27, 4, '2023-12-21', 12.39, 'UI/L', 'Légèrement bas'),
(16, 4, '2023-04-08', 65.38, 'mg/dL', 'Légèrement élevé'),
(77, 5, '2023-02-26', 177.38, 'mg/dL', 'Anormal'),
(92, 7, '2023-08-06', 44.76, 'UI/L', 'Anormal'),
(74, 5, '2023-12-20', 150.41, 'ng/mL', 'Légèrement élevé'),
(47, 9, '2023-09-27', 194.3, 'UI/L', 'Légèrement bas'),
(17, 7, '2023-11-23', 56.04, 'ng/mL', 'Valeur normale'),
(96, 5, '2023-01-28', 65.42, 'g/L', 'Anormal'),
(6, 4, '2023-05-04', 82.2, 'mg/dL', 'Valeur normale'),
(7, 10, '2023-08-03', 177.44, 'UI/L', 'Valeur normale'),
(44, 2, '2023-11-25', 49.93, 'ng/mL', 'Légèrement élevé'),
(20, 8, '2023-06-14', 115.67, 'g/L', 'Anormal'),
(81, 9, '2023-05-30', 190.77, 'ng/mL', 'Anormal'),
(25, 4, '2023-04-09', 88.23, 'mg/dL', 'Légèrement élevé'),
(29, 1, '2023-12-30', 122.37, 'g/L', 'Valeur normale'),
(97, 2, '2023-07-28', 177.92, 'UI/L', 'Légèrement bas'),
(20, 9, '2023-09-19', 17.49, 'g/L', 'Anormal'),
(53, 3, '2023-01-19', 192.56, 'g/L', 'Anormal'),
(42, 3, '2023-11-25', 112.12, 'UI/L', 'Valeur normale'),
(44, 9, '2023-11-18', 105.09, 'g/L', 'Anormal'),
(40, 1, '2023-04-04', 182.91, 'g/L', 'Valeur normale'),
(56, 6, '2023-06-27', 194.26, 'mg/dL', 'Anormal'),
(17, 10, '2023-10-02', 70.74, 'mg/dL', 'Légèrement bas'),
(68, 8, '2023-04-29', 51.73, 'mg/dL', 'Légèrement bas'),
(6, 9, '2023-07-31', 193.75, 'UI/L', 'Anormal'),
(68, 2, '2023-06-14', 74.68, 'UI/L', 'Valeur normale'),
(64, 8, '2023-12-01', 111.61, 'mg/dL', 'Anormal'),
(56, 1, '2023-06-01', 197.59, 'ng/mL', 'Valeur normale'),
(3, 4, '2023-03-02', 144.19, 'UI/L', 'Anormal'),
(54, 9, '2023-11-11', 183.46, 'UI/L', 'Légèrement élevé'),
(62, 4, '2023-09-23', 131.9, 'g/L', 'Anormal'),
(51, 8, '2023-04-26', 6.06, 'UI/L', 'Valeur normale'),
(18, 6, '2023-02-08', 67.36, 'mg/dL', 'Anormal'),
(50, 2, '2023-08-15', 148.45, 'g/L', 'Valeur normale'),
(15, 7, '2023-10-28', 99.16, 'mg/dL', 'Valeur normale'),
(13, 3, '2023-02-28', 50.51, 'ng/mL', 'Anormal'),
(18, 9, '2023-09-14', 63.25, 'mg/dL', 'Légèrement élevé'),
(68, 9, '2023-12-21', 107.36, 'mg/dL', 'Légèrement élevé'),
(84, 4, '2023-01-28', 170.62, 'g/L', 'Légèrement élevé'),
(82, 6, '2023-12-27', 45.15, 'g/L', 'Légèrement élevé'),
(80, 8, '2023-02-02', 37.92, 'UI/L', 'Anormal'),
(19, 7, '2023-06-18', 95.29, 'mg/dL', 'Anormal'),
(86, 9, '2023-04-01', 19.91, 'UI/L', 'Valeur normale'),
(24, 6, '2023-05-05', 188.43, 'g/L', 'Anormal'),
(98, 4, '2023-03-11', 5.04, 'UI/L', 'Anormal'),
(96, 2, '2023-09-15', 127.82, 'UI/L', 'Légèrement bas'),
(80, 5, '2023-11-18', 23.78, 'ng/mL', 'Anormal'),
(70, 1, '2023-04-25', 38.47, 'UI/L', 'Valeur normale'),
(29, 1, '2023-10-23', 136.01, 'ng/mL', 'Valeur normale'),
(45, 6, '2023-06-27', 127.03, 'ng/mL', 'Légèrement élevé'),
(67, 9, '2023-10-13', 43.53, 'g/L', 'Légèrement élevé'),
(78, 2, '2023-08-22', 178.6, 'UI/L', 'Anormal'),
(18, 9, '2023-01-04', 164.67, 'g/L', 'Anormal'),
(22, 3, '2023-04-28', 111.96, 'ng/mL', 'Anormal'),
(82, 1, '2023-12-30', 82.12, 'ng/mL', 'Légèrement élevé'),
(3, 7, '2023-04-27', 102.49, 'g/L', 'Anormal'),
(91, 5, '2023-08-28', 112.2, 'ng/mL', 'Légèrement bas'),
(81, 9, '2023-06-26', 5.95, 'g/L', 'Anormal'),
(89, 4, '2023-08-11', 76.78, 'g/L', 'Anormal'),
(51, 8, '2023-11-28', 47.69, 'g/L', 'Légèrement élevé'),
(91, 1, '2023-03-07', 96.41, 'UI/L', 'Anormal'),
(93, 1, '2023-09-02', 108.87, 'mg/dL', 'Légèrement élevé'),
(86, 6, '2023-06-22', 122.13, 'UI/L', 'Valeur normale'),
(19, 2, '2023-09-26', 101.87, 'UI/L', 'Légèrement élevé'),
(35, 2, '2023-07-31', 107.01, 'ng/mL', 'Légèrement bas'),
(17, 3, '2023-11-16', 107.55, 'ng/mL', 'Anormal'),
(82, 3, '2023-01-02', 157.68, 'mg/dL', 'Anormal'),
(19, 10, '2023-06-07', 148.51, 'ng/mL', 'Anormal'),
(61, 4, '2023-02-17', 89.31, 'mg/dL', 'Légèrement élevé'),
(6, 1, '2023-04-04', 126.89, 'UI/L', 'Valeur normale'),
(44, 2, '2023-09-18', 40.26, 'g/L', 'Valeur normale'),
(46, 1, '2023-05-11', 17.67, 'UI/L', 'Légèrement bas'),
(10, 10, '2023-01-21', 184.62, 'UI/L', 'Légèrement bas'),
(54, 5, '2023-11-12', 37.14, 'mg/dL', 'Valeur normale'),
(7, 6, '2023-07-21', 197.77, 'mg/dL', 'Légèrement élevé'),
(78, 4, '2023-02-09', 93.63, 'g/L', 'Légèrement élevé'),
(99, 6, '2023-04-17', 141.1, 'ng/mL', 'Légèrement bas'),
(30, 7, '2023-04-27', 68.05, 'UI/L', 'Valeur normale'),
(30, 9, '2023-03-06', 132.84, 'ng/mL', 'Anormal'),
(7, 5, '2023-10-09', 35.19, 'UI/L', 'Valeur normale');
